/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.action;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.capture.action.CaptureAction;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_5819;

public class FlashAction
implements CaptureAction {
    private final class_1297 cameraHolder;
    private long initializedAt;

    public FlashAction(class_1297 cameraHolder) {
        this.cameraHolder = cameraHolder;
    }

    @Override
    public int requiredDelayTicks() {
        return (Integer)Config.Client.FLASH_CAPTURE_DELAY_TICKS.get();
    }

    @Override
    public void initialize() {
        this.initializedAt = this.cameraHolder.method_37908().method_8510();
    }

    @Override
    public void beforeCapture() {
        long ticksDelay = this.cameraHolder.method_37908().method_8510() - this.initializedAt;
        if (ticksDelay > 8L) {
            Exposure.LOGGER.warn("Capturing with delay of '{}' ticks can be too long for a flash to have an effect. The flash might disappear in that time.", (Object)ticksDelay);
        }
    }

    @Override
    public void afterCapture() {
        class_1937 level = this.cameraHolder.method_37908();
        class_243 pos = this.cameraHolder.method_19538();
        class_243 lookAngle = this.cameraHolder.method_5720();
        pos = pos.method_1031(0.0, 1.2, 0.0).method_1019(lookAngle.method_18805((double)0.8f, (double)0.8f, (double)0.8f));
        class_5819 r = level.method_8409();
        for (int i = 0; i < 3; ++i) {
            level.method_8406((class_2394)class_2398.field_11207, pos.field_1352 + (double)r.method_43057() - 0.5, pos.field_1351 + (double)r.method_43057() + (double)0.15f, pos.field_1350 + (double)r.method_43057() - 0.5, lookAngle.field_1352 * (double)0.025f + (double)(r.method_43057() * 0.025f), lookAngle.field_1351 * (double)0.025f + (double)(r.method_43057() * 0.025f), lookAngle.field_1350 * (double)0.025f + (double)(r.method_43057() * 0.025f));
        }
    }
}

